Attribute VB_Name = "mdMirrorInBoth"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience function to mirror a set of lines with X and Y axis as mirror lines

Sub MirrorInBoth(lineSet As ObjectSet)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim mrlineSet As ObjectSet
Set mrlineSet = Part.MirrorLines(lineSet, sketch, wp.GetLocalX)

'mrlineSet.AddSet Part.MirrorLines(mrlineSet, sketch, wp.GetLocalY)
'mrlineSet.AddSet Part.MirrorLines(lineSet, sketch, wp.GetLocalY)

Call AddSet(mrlineSet, Part.MirrorLines(mrlineSet, sketch, wp.GetLocalY))
Call AddSet(mrlineSet, Part.MirrorLines(lineSet, sketch, wp.GetLocalY))

Part.SetSelection lineSet

wp.AutoConstrain lineSet


End Sub

Sub AddSet(destinationSet, sourceSet)

Dim it As Iterator
Set it = app.GetClass("It").CreateAObjectIt(sourceSet)
destinationSet.AddMember it.start
Do While it.IsActive
    destinationSet.AddMember it.Current
    it.Next
Loop
End Sub


